#import "AMapPathPolyline.h"
#import "Coordinate.h"

#pragma ide diagnostic ignored "OCUnusedMethodInspection"

@implementation AMapPathPolyline {
    MAPolyline *_polyline;
    MAPolylineRenderer *_renderer;

    UIImage *_image;
    CGFloat _width;
    UIColor *_color;
    NSArray *_colors;
    BOOL _dashed;
    BOOL _gradient;
}

- (instancetype)init {
    if (self = [super init]) {
        _polyline = [MAPolyline polylineWithCoordinates:nil count:0];
    }

    return self;
}

- (void)setCoordinates:(NSArray<Coordinate *> *)coordinates {
    CLLocationCoordinate2D coords[coordinates.count];
    for (NSUInteger i = 0; i < coordinates.count; i++) {
        coords[i] = coordinates[i].coordinate;
    }

    [_polyline setPolylineWithCoordinates:coords count:coordinates.count];
}

- (void)setWidth:(CGFloat)width {
    _width = width;
    _renderer.lineWidth = width;
}

- (void)setColor:(UIColor *)color {
    _color = color;
    _renderer.strokeColor = color;
}

- (CLLocationCoordinate2D)coordinate {
    return _polyline.coordinate;
}

- (MAMapRect)boundingMapRect {
    return _polyline.boundingMapRect;
}

- (void)setImage:(NSString *)name {

    _image = [UIImage imageNamed:name];
    //UIImage *temp = [UIImage imageNamed:@"path8"];
    //_renderer.strokeTextureImages = _images;
    //[_polyline setDrawStyleIndexes:@[@(1),@(2)]];
}

- (MAOverlayRenderer *)renderer {
    if (_color == nil) {
        _color = UIColor.blackColor;
    }
    if (_renderer == nil) {
        _renderer = [[MAPolylineRenderer alloc] initWithPolyline:_polyline];
        _renderer.lineWidth = _width;
        _renderer.strokeColor = _color;
        //[_renderer loadTexture:[UIImage imageNamed:@"path8"]];
        if(_image != nil){
            [_renderer loadStrokeTextureImage:_image];
        }
        //_renderer.strokeTextureImages = _images;
    }
    return _renderer;
}

@end
