#import <React/UIView+React.h>
#import "AMapSmoothMoveMarker.h"
#import "Coordinate.h"

#pragma ide diagnostic ignored "OCUnusedMethodInspection"
#pragma clang diagnostic ignored "-Woverriding-method-mismatch"

@implementation AMapSmoothMoveMarker {
    MAAnimatedAnnotation *_annotation;//贴图标注
    MAAnnotationView *_annotationView;//标注视图
    MACustomCalloutView *_calloutView;//气泡视图
    NSMutableArray<Coordinate *> *_coordinates;//
    UIView *_customView;
    __weak AMapView *_mapView;
    MAPinAnnotationColor _pinColor;
    UIImage *_image;
    CGPoint _centerOffset;
    BOOL _draggable;
    BOOL _active;
    BOOL _canShowCallout; //是否显示气泡
    BOOL _enabled;
    NSInteger _zIndex;
    NSInteger _duration; //动画时间
}

- (instancetype)init {
    _annotation = [MAAnimatedAnnotation new];
    _coordinates = [[NSMutableArray alloc] init];
    _enabled = YES;
    _canShowCallout = YES;
    self = [super init];
    return self;
}

- (void)setDuration:(NSInteger)duration {
    _duration = duration;
}

- (void)setImage:(NSString *)name {
    _image = [UIImage imageNamed:name];
    if (_image != nil) {
        _annotationView.image = _image;
    }
}

- (void)setCoordinates:(NSArray<Coordinate *> *)coordinates {
    [_coordinates removeAllObjects];
    [_coordinates addObjectsFromArray:coordinates];
    CLLocationCoordinate2D coords[coordinates.count];
    for (NSUInteger i = 0; i < coordinates.count; i++) {
        coords[i] = coordinates[i].coordinate;
    }
    _annotation.coordinate = coords[0];
    //_annotation.title = @"I can fly!";
    if(_annotationView != nil) {
        [_annotation addMoveAnimationWithKeyCoordinates:coords count:coordinates.count-1 withDuration:_duration withName:nil completeCallback:^(BOOL isFinished) { 

           }];
    }
}

- (void)setActive:(BOOL)active {
    _active = active;
    dispatch_async(dispatch_get_main_queue(), ^{
        if (active) {
            [_mapView selectAnnotation:_annotation animated:YES];
        } else {
            [_mapView deselectAnnotation:_annotation animated:YES];
        }
    });
}

- (MAAnimatedAnnotation *)annotation {
    return _annotation;
}

- (void)setMapView:(AMapView *)mapView {
    _mapView = mapView;
}

- (void)_handleTap:(UITapGestureRecognizer *)recognizer {
    [_mapView selectAnnotation:_annotation animated:YES];
}

- (MAAnnotationView *)annotationView {
    if (_annotationView == nil) {
        if (_customView) {
            _customView.hidden = NO;
            _annotationView = [[MAAnnotationView alloc] initWithAnnotation:_annotation reuseIdentifier:nil];
            _annotationView.bounds = _customView.bounds;
            [_annotationView addSubview:_customView];
            [_annotationView addGestureRecognizer:[
                    [UITapGestureRecognizer alloc] initWithTarget:self action:@selector(_handleTap:)]];
        } else {
            _annotationView = [[MAPinAnnotationView alloc] initWithAnnotation:_annotation reuseIdentifier:nil];
            ((MAPinAnnotationView *) _annotationView).pinColor = _pinColor;
        }

        _annotationView.enabled = _enabled;
        _annotationView.canShowCallout = _canShowCallout;
        _annotationView.draggable = _draggable;
        _annotationView.customCalloutView = _calloutView;
        _annotationView.centerOffset = _centerOffset;

        if (_zIndex) {
            _annotationView.zIndex = _zIndex;
        }

        if (_image != nil) {
            _annotationView.image = _image;
        }
        CLLocationCoordinate2D coords[_coordinates.count];
        for (NSUInteger i = 0; i < _coordinates.count; i++) {
            coords[i] = _coordinates[i].coordinate;
        }
        [_annotation addMoveAnimationWithKeyCoordinates:coords count:_coordinates.count-1 withDuration:_duration withName:nil completeCallback:^(BOOL isFinished) {  

          }];
    [self setActive:_active];
    }
    return _annotationView;
}

- (void)didAddSubview:(UIView *)subview {
    if ([subview isKindOfClass:[AMapCallout class]]) {
        _calloutView = [[MACustomCalloutView alloc] initWithCustomView:subview];
        _annotationView.customCalloutView = _calloutView;
    } else {
        _customView = subview;
        _customView.hidden = YES;
    }
}

- (void)lockToScreen:(int)x y:(int)y {
    _annotation.lockedToScreen = YES;
    _annotation.lockedScreenPoint = CGPointMake(x, y);
}

@end
