#import <React/RCTUIManager.h>
#import "AMapSmoothMoveMarker.h"

#pragma ide diagnostic ignored "OCUnusedClassInspection"

@interface AMapSmoothMoveMarkerManager : RCTViewManager
@end

@implementation AMapSmoothMoveMarkerManager {
}

RCT_EXPORT_MODULE()

- (UIView *)view {
    return [AMapSmoothMoveMarker new];
}

RCT_EXPORT_VIEW_PROPERTY(coordinates, CoordinateArray)
RCT_EXPORT_VIEW_PROPERTY(duration, NSInteger)
RCT_EXPORT_VIEW_PROPERTY(image, NSString)

RCT_EXPORT_VIEW_PROPERTY(onPress, RCTBubblingEventBlock)


RCT_EXPORT_METHOD(lockToScreen:(nonnull NSNumber *)reactTag x:(int)x y:(int)y) {
    [self.bridge.uiManager addUIBlock:^(__unused RCTUIManager *uiManager, NSDictionary<NSNumber *, UIView *> *viewRegistry) {
        AMapSmoothMoveMarker *marker = (AMapSmoothMoveMarker *) viewRegistry[reactTag];
        [marker lockToScreen:x y:y];
    }];
}

RCT_EXPORT_METHOD(active:(nonnull NSNumber *)reactTag) {
    [self.bridge.uiManager addUIBlock:^(__unused RCTUIManager *uiManager, NSDictionary<NSNumber *, UIView *> *viewRegistry) {
        AMapSmoothMoveMarker *marker = (AMapSmoothMoveMarker *) viewRegistry[reactTag];
        marker.active = YES;
    }];
}

@end
