// @flow
import React from 'react'
import PropTypes from 'prop-types'
import { Platform, requireNativeComponent, StyleSheet, ViewPropTypes, View } from 'react-native'
import { LatLng, Point } from '../PropTypes'
import Component from '../Component'

const style = StyleSheet.create({
  overlay: {
    position: 'absolute',
  },
})

export default class SmoothMoveMarker extends Component<any> {
  static propTypes = {
    ...ViewPropTypes,
    /**
     * 节点坐标
     */
    coordinates: PropTypes.arrayOf(LatLng).isRequired,    
    /**
     * 动画时间
     */
    duration: PropTypes.number,        
    /**
     * 自定义图片，对应原生图片名称
     */
    image: PropTypes.string,
    /**
     * 点击事件
     */
    onPress: PropTypes.func
  }

  componentDidMount() {
  }

  render() {
    return (
      <AMapSmoothMoveMarker {...this.props}>
      </AMapSmoothMoveMarker>
    )
  }
}

const AMapSmoothMoveMarker = requireNativeComponent('AMapSmoothMoveMarker', SmoothMoveMarker)
