package cn.qiuxiang.react.amap3d.maps

import android.content.Context
import android.graphics.Bitmap
import android.graphics.Canvas
import android.view.View
import android.graphics.Color
import cn.qiuxiang.react.amap3d.toPx
import cn.qiuxiang.react.amap3d.toLatLngList
import com.amap.api.maps.AMap
import com.amap.api.maps.model.LatLng
import com.amap.api.maps.model.Polygon
import com.amap.api.maps.model.PolygonOptions
import com.amap.api.maps.model.*
import com.facebook.react.bridge.ReadableArray
import com.facebook.react.views.view.ReactViewGroup

class AMapPathPolyline(context: Context) : ReactViewGroup(context), AMapOverlay {

    var polyline: Polyline? = null
        private set

    private var coordinates: ArrayList<LatLng> = ArrayList()
    private var colors: ArrayList<Int> = ArrayList()
    private var bitmapDescriptor: BitmapDescriptor? = null
    //private var bitmapDescriptor1: BitmapDescriptor? = null
    //private var bitmapDescriptor2: BitmapDescriptor? = null

    var width: Float = 1f
        set(value) {
            field = value
            polyline?.width = value
        }

    var color: Int = Color.BLACK
        set(value) {
            field = value
            polyline?.color = value
        }

    var zIndex: Float = 0f
        set(value) {
            field = value
            polyline?.zIndex = value
        }

    var geodesic: Boolean = false
        set(value) {
            field = value
            polyline?.isGeodesic = value
        }

    var dashed: Boolean = false
        set(value) {
            field = value
            polyline?.isDottedLine = value
        }

    var gradient: Boolean = false

    fun setCoordinates(coordinates: ReadableArray) {
        this.coordinates = coordinates.toLatLngList()
        polyline?.points = this.coordinates
    }

    fun setColors(colors: ReadableArray) {
        this.colors = ArrayList((0 until colors.size()).map { colors.getInt(it) })
    }

    fun setImage(name: String) {
        val drawable = context.resources.getIdentifier(name, "drawable", context.packageName)
        //val drawable1 = context.resources.getIdentifier("p16x16_1", "drawable", context.packageName)
        //val drawable2 = context.resources.getIdentifier("p16x16_1", "drawable", context.packageName)
        bitmapDescriptor = BitmapDescriptorFactory.fromResource(drawable)
        //bitmapDescriptor1 = BitmapDescriptorFactory.fromResource(drawable1)
        //bitmapDescriptor2 = BitmapDescriptorFactory.fromResource(drawable2)
    }

    override fun add(map: AMap) {
        polyline = map.addPolyline(PolylineOptions()
                .setCustomTexture(bitmapDescriptor)
                //.setCustomTextureIndex(listOf(0, 1, 2))
                //.setCustomTextureList(listOf(bitmapDescriptor1,bitmapDescriptor,bitmapDescriptor2))
                .setUseTexture(true)        
                .addAll(coordinates)
                // .color(color)
                // .colorValues(colors)
                .width(width)
                .useGradient(gradient)
                .geodesic(geodesic)
                .setDottedLine(dashed)
                .zIndex(zIndex))
    }

    override fun remove() {
        polyline?.remove()
    }
}
