package cn.qiuxiang.react.amap3d.maps

import cn.qiuxiang.react.amap3d.toPx
import com.facebook.react.bridge.ReadableArray
import com.facebook.react.uimanager.SimpleViewManager
import com.facebook.react.uimanager.ThemedReactContext
import com.facebook.react.uimanager.annotations.ReactProp

@Suppress("unused")
internal class AMapPathPolylineManager : SimpleViewManager<AMapPathPolyline>() {
    override fun getName(): String {
        return "AMapPathPolyline"
    }

    override fun createViewInstance(reactContext: ThemedReactContext): AMapPathPolyline {
        return AMapPathPolyline(reactContext)
    }

    override fun getExportedCustomDirectEventTypeConstants(): Map<String, Any> {
        return mapOf("onPress" to mapOf("registrationName" to "onPress"))
    }

    @ReactProp(name = "coordinates")
    fun setCoordinate(polyline: AMapPathPolyline, coordinates: ReadableArray) {
        polyline.setCoordinates(coordinates)
    }

    @ReactProp(name = "colors")
    fun setColors(polyline: AMapPathPolyline, colors: ReadableArray) {
        polyline.setColors(colors)
    }

    @ReactProp(name = "color", customType = "Color")
    fun setColor(polyline: AMapPathPolyline, color: Int) {
        polyline.color = color
    }

    @ReactProp(name = "width")
    fun setWidth(polyline: AMapPathPolyline, width: Float) {
        polyline.width = width.toPx().toFloat()
    }

    @ReactProp(name = "zIndex")
    fun setZIndex_(polyline: AMapPathPolyline, zIndex: Float) {
        polyline.zIndex = zIndex
    }

    @ReactProp(name = "geodesic")
    fun setGeodesic(polyline: AMapPathPolyline, geodesic: Boolean) {
        polyline.geodesic = geodesic
    }

    @ReactProp(name = "dashed")
    fun setDashed(polyline: AMapPathPolyline, dashed: Boolean) {
        polyline.dashed = dashed
    }

    @ReactProp(name = "gradient")
    fun setGradient(polyline: AMapPathPolyline, gradient: Boolean) {
        polyline.gradient = gradient
    }

    @ReactProp(name = "image")
    fun setImage(polygon: AMapPathPolyline, image: String) {
        polygon.setImage(image)
    }
}
