package cn.qiuxiang.react.amap3d.maps

import android.content.Context
import android.graphics.Bitmap
import android.graphics.Canvas
import android.view.View
import cn.qiuxiang.react.amap3d.toPx
import com.amap.api.maps.utils.overlay.*
import com.amap.api.maps.AMap
import com.amap.api.maps.CameraUpdateFactory
import cn.qiuxiang.react.amap3d.toLatLngList
import com.amap.api.maps.model.LatLngBounds
import com.amap.api.maps.model.*
import com.amap.api.maps.utils.*
import com.facebook.react.bridge.ReadableArray
import com.facebook.react.views.view.ReactViewGroup


class AMapSmoothMoveMarker(context: Context) : ReactViewGroup(context), AMapOverlay {
    private var bitmapDescriptor: BitmapDescriptor? = null
    private var coordinates: ArrayList<LatLng> = ArrayList()
    private var lastImage: String? = null
    
    var marker: SmoothMoveMarker? = null
        private set

    var duration: Int = 3
        set(value) {
            field = value
        }

    fun setImage(name: String) {
        //重置图片
        if(lastImage != name) {
            val drawable = context.resources.getIdentifier(name, "drawable", context.packageName)
            bitmapDescriptor = BitmapDescriptorFactory.fromResource(drawable)
            lastImage = name
            marker?.setDescriptor(bitmapDescriptor)
        }
    }

    fun setCoordinates(coordinates: ReadableArray) {
        this.coordinates = coordinates.toLatLngList()
        this.startSmoothMove()
    }

    fun startSmoothMove(){
        var drivePoint:LatLng  = this.coordinates.get(0)
        var pair = SpatialRelationUtil.calShortestDistancePoint(this.coordinates, drivePoint)
        this.coordinates.set(pair.first, drivePoint)
        var subList = this.coordinates.subList(pair.first, this.coordinates.size)

        // 设置滑动的轨迹左边点
        marker?.setPoints(subList)
        // 设置滑动的总时间
        marker?.setTotalDuration(duration)
        // 开始滑动
        marker?.startSmoothMove()
    }

    override fun add(map: AMap) {
        // 获取轨迹坐标点
        //{latitude:27.7218139558361,longitude:103.898145251009},{latitude:27.7358139558361,longitude:103.895145251009}
        // var points:MutableList<LatLng> = ArrayList()
        // points.add(LatLng(27.7218139558361,103.898145251009))
        // points.add(LatLng(27.7358139558361,103.895145251009))
        // var bounds = LatLngBounds(points.get(0), points.get(points.size - 2))
        // map.animateCamera(CameraUpdateFactory.newLatLngBounds(bounds, 50))

        marker = SmoothMoveMarker(map)
        //设置滑动的图标
        //bitmapDescriptor = BitmapDescriptorFactory.fromResource(drawable)
        marker?.setDescriptor(bitmapDescriptor)

        // var drivePoint:LatLng  = coordinates.get(0)
        // var pair = SpatialRelationUtil.calShortestDistancePoint(coordinates, drivePoint)
        // coordinates.set(pair.first, drivePoint)
        // var subList = coordinates.subList(pair.first, coordinates.size)

        // // 设置滑动的轨迹左边点
        // marker?.setPoints(subList)
        // // 设置滑动的总时间
        // marker?.setTotalDuration(duration)
        // // 开始滑动
        // marker?.startSmoothMove()
        this.startSmoothMove();
    }

    override fun remove() {
        marker?.destroy()
    }
}
