package cn.qiuxiang.react.amap3d.maps

import android.view.View
import cn.qiuxiang.react.amap3d.toLatLng
import com.amap.api.maps.model.LatLng
import com.facebook.react.bridge.ReadableArray
import com.facebook.react.bridge.ReadableMap
import com.facebook.react.bridge.ReactMethod
import com.facebook.react.common.MapBuilder
import com.facebook.react.uimanager.ThemedReactContext
import com.facebook.react.uimanager.ViewGroupManager
import com.facebook.react.uimanager.annotations.ReactProp

@Suppress("unused")
internal class AMapSmoothMoveMarkerManager : ViewGroupManager<AMapSmoothMoveMarker>() {
    override fun getName(): String {
        return "AMapSmoothMoveMarker"
    }

    override fun createViewInstance(reactContext: ThemedReactContext): AMapSmoothMoveMarker {
        return AMapSmoothMoveMarker(reactContext)
    }


    override fun getExportedCustomDirectEventTypeConstants(): Map<String, Any>? {
        return MapBuilder.of(
                "onPress", MapBuilder.of("registrationName", "onPress"))
    }

    @ReactProp(name = "coordinates")
    fun setCoordinate(marker: AMapSmoothMoveMarker, coordinates: ReadableArray) {
        marker.setCoordinates(coordinates)
    }

    @ReactProp(name = "duration")
    fun setCoordinate(marker: AMapSmoothMoveMarker, duration: Int) {
        marker.duration = duration
    }

    @ReactProp(name = "image")
    fun setImage(marker: AMapSmoothMoveMarker, image: String) {
        marker.setImage(image)
    }

    @ReactMethod
    fun startSmoothMove(marker: AMapSmoothMoveMarker) {
        marker.startSmoothMove()
    }
}
